/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.blocks.devices;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.dries007.tfc.Constants;
import net.dries007.tfc.api.util.IBellowsConsumerBlock;
import net.dries007.tfc.client.TFCGuiHandler;
import net.dries007.tfc.client.particle.TFCParticles;
import net.dries007.tfc.objects.advancements.TFCTriggers;
import net.dries007.tfc.objects.blocks.property.ILightableBlock;
import net.dries007.tfc.objects.fluids.FluidsTFC;
import net.dries007.tfc.objects.items.ItemFireStarter;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.objects.te.TEBellows;
import net.dries007.tfc.objects.te.TEFirePit;
import net.dries007.tfc.util.DamageSourcesTFC;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.OreDictionaryHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@ParametersAreNonnullByDefault
public class BlockFirePit
extends Block
implements IBellowsConsumerBlock,
ILightableBlock {
    public static final PropertyEnum<FirePitAttachment> ATTACHMENT = PropertyEnum.func_177709_a((String)"attachment", FirePitAttachment.class);
    private static final AxisAlignedBB FIREPIT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    private static final AxisAlignedBB FIREPIT_ATTACHMENT_SELECTION_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
    private static final AxisAlignedBB ATTACHMENT_COLLISION_ADDITION_AABB = new AxisAlignedBB(0.1875, 0.125, 0.1875, 0.8125, 0.9375, 0.8125);

    public BlockFirePit() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177226_a(ATTACHMENT, (Comparable)((Object)FirePitAttachment.NONE)));
        this.func_149649_H();
        this.func_149675_a(true);
        this.func_149715_a(1.0f);
        this.func_149711_c(0.3f);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 1) > 0)).func_177226_a(ATTACHMENT, (Comparable)((Object)FirePitAttachment.valueOf(meta >> 1)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 1 : 0) + (((FirePitAttachment)((Object)state.func_177229_b(ATTACHMENT))).ordinal() << 1);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(ATTACHMENT) != FirePitAttachment.NONE) {
            return FIREPIT_ATTACHMENT_SELECTION_AABB;
        }
        return FIREPIT_AABB;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockFirePit.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)FIREPIT_AABB);
        if (state.func_177229_b(ATTACHMENT) != FirePitAttachment.NONE) {
            BlockFirePit.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)ATTACHMENT_COLLISION_ADDITION_AABB);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random random) {
        TEFirePit te = Helpers.getTE((IBlockAccess)worldIn, pos, TEFirePit.class);
        if (te != null && ((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && worldIn.func_175727_C(pos.func_177984_a())) {
            te.onRainDrop();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rng) {
        IItemHandler cap;
        TEFirePit tile;
        if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return;
        }
        if (rng.nextInt(24) == 0) {
            world.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rng.nextFloat(), rng.nextFloat() * 0.7f + 0.3f, false);
        }
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.1;
        double z = (double)pos.func_177952_p() + 0.5;
        switch (rng.nextInt(3)) {
            case 0: {
                TFCParticles.FIRE_PIT_SMOKE1.spawn(world, x, y, z, 0.0, 0.1, 0.0, 120);
                break;
            }
            case 1: {
                TFCParticles.FIRE_PIT_SMOKE2.spawn(world, x, y, z, 0.0, 0.1, 0.0, 110);
                break;
            }
            case 2: {
                TFCParticles.FIRE_PIT_SMOKE3.spawn(world, x, y, z, 0.0, 0.1, 0.0, 100);
            }
        }
        if (state.func_177229_b(ATTACHMENT) == FirePitAttachment.COOKING_POT && (tile = Helpers.getTE((IBlockAccess)world, pos, TEFirePit.class)) != null && tile.getCookingPotStage() == TEFirePit.CookingPotStage.BOILING) {
            for (int i = 0; i < rng.nextInt(5) + 4; ++i) {
                TFCParticles.BUBBLE.spawn(world, x + (double)rng.nextFloat() * 0.375 - 0.1875, y + 0.525, z + (double)rng.nextFloat() * 0.375 - 0.1875, 0.0, 0.05, 0.0, 3);
            }
            TFCParticles.STEAM.spawn(world, x, y + (double)0.425f, z, 0.0, 0.0, 0.0, (int)(12.0f / (rng.nextFloat() * 0.9f + 0.1f)));
            world.func_184134_a(x, y + (double)0.425f, z, SoundEvents.field_187917_gq, SoundCategory.BLOCKS, 1.0f, rng.nextFloat() * 0.7f + 0.4f, false);
        }
        if (state.func_177229_b(ATTACHMENT) == FirePitAttachment.GRILL && (tile = Helpers.getTE((IBlockAccess)world, pos, TEFirePit.class)) != null && (cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
            boolean anythingInInv = false;
            for (int i = 7; i <= 11; ++i) {
                if (cap.getStackInSlot(i).func_190926_b()) continue;
                anythingInInv = true;
                break;
            }
            if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && anythingInInv) {
                world.func_184134_a(x, y + (double)0.425f, z, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.25f, rng.nextFloat() * 0.7f + 0.4f, false);
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + (double)(rng.nextFloat() / 2.0f) - 0.25, y + 0.6, z + (double)(rng.nextFloat() / 2.0f) - 0.25, 0.0, 0.1, 0.0, new int[0]);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBePlacedOn(worldIn, pos.func_177982_a(0, -1, 0))) {
            worldIn.func_175698_g(pos);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TEFirePit tile = Helpers.getTE((IBlockAccess)worldIn, pos, TEFirePit.class);
        if (tile != null) {
            tile.onBreakBlock(worldIn, pos, state);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    @Nonnull
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.canBePlacedOn(worldIn, pos.func_177982_a(0, -1, 0));
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack held = player.func_184586_b(hand);
            if (!((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && ItemFireStarter.onIgnition(held)) {
                TFCTriggers.LIT_TRIGGER.trigger((EntityPlayerMP)player, state.func_177230_c());
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
                return true;
            }
            FirePitAttachment attachment = (FirePitAttachment)((Object)state.func_177229_b(ATTACHMENT));
            TEFirePit tile = Helpers.getTE((IBlockAccess)worldIn, pos, TEFirePit.class);
            if (tile != null) {
                if (attachment == FirePitAttachment.NONE) {
                    if (OreDictionaryHelper.doesStackMatchOre(held, "cookingPot")) {
                        worldIn.func_175656_a(pos, state.func_177226_a(ATTACHMENT, (Comparable)((Object)FirePitAttachment.COOKING_POT)));
                        tile.onConvertToCookingPot(player, held);
                        return true;
                    }
                    if (OreDictionaryHelper.doesStackMatchOre(held, "grill")) {
                        worldIn.func_175656_a(pos, state.func_177226_a(ATTACHMENT, (Comparable)((Object)FirePitAttachment.GRILL)));
                        tile.onConvertToGrill(player, held);
                        return true;
                    }
                } else if (attachment == FirePitAttachment.COOKING_POT) {
                    if (tile.getCookingPotStage() == TEFirePit.CookingPotStage.EMPTY) {
                        FluidStack fluidStack = FluidUtil.getFluidContained((ItemStack)held);
                        if (fluidStack != null && fluidStack.amount >= 1000 && fluidStack.getFluid() == FluidsTFC.FRESH_WATER.get()) {
                            tile.addWaterToCookingPot();
                            IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)held);
                            if (fluidHandler != null) {
                                fluidHandler.drain(1000, true);
                            }
                            worldIn.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 0.5f, 1.0f);
                            return true;
                        }
                    } else if (tile.getCookingPotStage() == TEFirePit.CookingPotStage.FINISHED && OreDictionaryHelper.doesStackMatchOre(held, "bowl")) {
                        tile.onUseBowlOnCookingPot(player, held);
                        return true;
                    }
                }
            }
            if (!player.func_70093_af()) {
                TFCGuiHandler.openGui(worldIn, pos, player, TFCGuiHandler.Type.FIRE_PIT);
            } else if (held == ItemStack.field_190927_a && attachment != FirePitAttachment.NONE) {
                IItemHandler cap;
                boolean anythingInTheInv = false;
                if (tile != null && (cap = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                    for (int i = 7; i <= 11; ++i) {
                        if (cap.getStackInSlot(i).func_190926_b()) continue;
                        anythingInTheInv = true;
                        break;
                    }
                    if (!anythingInTheInv) {
                        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
                            if (attachment == FirePitAttachment.COOKING_POT) {
                                player.func_70097_a(DamageSourcesTFC.SOUP, 1.0f);
                            } else {
                                player.func_70097_a(DamageSourcesTFC.GRILL, 1.0f);
                            }
                        } else {
                            tile.onRemoveAttachment(player, held);
                            worldIn.func_175656_a(pos, state.func_177226_a(ATTACHMENT, (Comparable)((Object)FirePitAttachment.NONE)));
                            return true;
                        }
                    }
                }
            }
        }
        return true;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && !entityIn.func_70045_F() && entityIn instanceof EntityLivingBase) {
            entityIn.func_70097_a(DamageSource.field_76372_a, 1.0f);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue() && !entityIn.func_70045_F() && entityIn instanceof EntityLivingBase) {
            entityIn.func_70097_a(DamageSource.field_76372_a, 1.0f);
        }
        super.func_180634_a(worldIn, pos, state, entityIn);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIT, ATTACHMENT});
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? super.getLightValue(state, world, pos) : 0;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TEFirePit();
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(ItemsTFC.WOOD_ASH, 3 + Constants.RNG.nextInt(5)));
    }

    @Nullable
    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EntityLiving entity) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false && (entity == null || !entity.func_70045_F()) ? PathNodeType.DAMAGE_FIRE : null;
    }

    @Override
    public boolean canIntakeFrom(Vec3i offset, EnumFacing facing) {
        return offset.equals((Object)TEBellows.OFFSET_LEVEL);
    }

    @Override
    public void onAirIntake(World world, BlockPos pos, int airAmount) {
        TEFirePit teFirePit = Helpers.getTE((IBlockAccess)world, pos, TEFirePit.class);
        if (teFirePit != null) {
            teFirePit.onAirIntake(airAmount);
        }
    }

    private boolean canBePlacedOn(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    public static enum FirePitAttachment implements IStringSerializable
    {
        NONE,
        GRILL,
        COOKING_POT;

        private static final FirePitAttachment[] VALUES;

        public static FirePitAttachment valueOf(int i) {
            return i < 0 || i >= VALUES.length ? NONE : VALUES[i];
        }

        @Nonnull
        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        static {
            VALUES = FirePitAttachment.values();
        }
    }
}

